//
//  WhereAmIViewController.m
//  WhereAmI
//
//  Created by Robert Górczyński on 11-07-27.
//

#import "WhereAmIViewController.h"

@implementation WhereAmIViewController
@synthesize locationManager; 
@synthesize startingPoint; 
@synthesize latitudeLabel; 
@synthesize longitudeLabel; 
@synthesize horizontalAccuracyLabel; 
@synthesize altitudeLabel;
@synthesize verticalAccuracyLabel; 
@synthesize distanceTraveledLabel; 

#pragma mark - 
- (void)viewDidLoad { 
    self.locationManager = [[CLLocationManager alloc] init]; 
    locationManager.delegate = self; 
    locationManager.desiredAccuracy = kCLLocationAccuracyBest; 
    [locationManager startUpdatingLocation]; 
} 

- (void)didReceiveMemoryWarning {
	// Jeżeli widok nie posiada widoku nadrzędnego, wówczas zostanie usunięty z pamięci.
    [super didReceiveMemoryWarning];
	
	// Usunięcie z pamięci wszelkich buforowanych danych, obrazów i innych zasobów, które obecnie nie są używane.
}

- (void)viewDidUnload {
	// Usunięcie wszystkich „przytrzymanych” podwidoków widoku głównego,
    // na przykład self.myOutlet = nil;
	self.locationManager = nil; 
	self.latitudeLabel = nil; 
	self.longitudeLabel = nil; 
	self.horizontalAccuracyLabel = nil; 
	self.altitudeLabel = nil; 
	self.verticalAccuracyLabel = nil; 
	self.distanceTraveledLabel= nil; 
	[super viewDidUnload]; 	
}


- (void)dealloc {
    [locationManager release]; 
    [startingPoint release]; 
    [latitudeLabel release]; 
    [longitudeLabel release]; 
    [horizontalAccuracyLabel release]; 
    [altitudeLabel release]; 
    [verticalAccuracyLabel release]; 
    [distanceTraveledLabel release]; 	
    [super dealloc];
}

#pragma mark - 
#pragma mark Metody delegata CLLocationManagerDelegate
- (void)locationManager:(CLLocationManager *)manager 
	didUpdateToLocation:(CLLocation *)newLocation 
		   fromLocation:(CLLocation *)oldLocation { 
	
	if (startingPoint == nil) 
		self.startingPoint = newLocation; 
	
	NSString *latitudeString = [[NSString alloc] initWithFormat:@"%g\u00B0", 
								newLocation.coordinate.latitude]; 
	latitudeLabel.text = latitudeString;
	[latitudeString release]; 
	
	NSString *longitudeString = [[NSString alloc] initWithFormat:@"%g\u00B0", 
								 newLocation.coordinate.longitude]; 
	longitudeLabel.text = longitudeString; 
	[longitudeString release]; 
	
	NSString *horizontalAccuracyString = [[NSString alloc] 
										  initWithFormat:@"%gm", 
										  newLocation.horizontalAccuracy]; 
	horizontalAccuracyLabel.text = horizontalAccuracyString; 
	[horizontalAccuracyString release]; 
	
	NSString *altitudeString = [[NSString alloc] initWithFormat:@"%gm", 
								newLocation.altitude]; 
	altitudeLabel.text = altitudeString; 
	[altitudeString release]; 
	
	NSString *verticalAccuracyString = [[NSString alloc] 
										initWithFormat:@"%gm", 
										newLocation.verticalAccuracy]; 
	verticalAccuracyLabel.text = verticalAccuracyString; 
	[verticalAccuracyString release]; 
	
	CLLocationDistance distance = [newLocation 
								   distanceFromLocation:startingPoint]; 
	NSString *distanceString = [[NSString alloc] 
								initWithFormat:@"%gm", distance]; 
	distanceTraveledLabel.text = distanceString; 
    [distanceString release]; 
} 

- (void)locationManager:(CLLocationManager *)manager 
       didFailWithError:(NSError *)error { 
	
    NSString *errorType = (error.code == kCLErrorDenied) ? 
	@"Brak dostępu" : @"Nieznany błąd"; 
    UIAlertView *alert = [[UIAlertView alloc] 
						  initWithTitle:@"Błąd podczas określania położenia" 
						  message:errorType 
						  delegate:nil 
						  cancelButtonTitle:@"OK" 
						  otherButtonTitles:nil]; 
    [alert show]; 
    [alert release]; 
} 
@end
